 ; Ŀ
 ;   Scabl - rescale all of one type of block in a drawing.                
 ;   Also Prop - rescale selected blocks to dimscale.                      
 ;        P1 - rescale selected blocks to 1.                               
 ;   Copyright 1994, 2005, 2007, 2008, 2010 by Rocket Software Ltd.        
 ;   The sound rats make running around in your walls,                     
 ;   or a word game for people who can't say "R".                          
 ; 

 ; Ŀ
 ;   Subroutine Gnam - Get a block name by input or selection.             
 ; 
 (DEFUN GNAM (str / blnam typp)
  (setq blnam (getstring str))
  (if (= blnam "")
      (progn
           (setq blnam (entsel
              "Pick an example block or <Return> for specific blocks: "))
           (if blnam (setq typp (cdr (assoc 0 (entget (car blnam))))))
           (if (= typp "INSERT")
               (progn
                    (setq blnam (cdr (assoc 2 (entget (car blnam)))))
                    (prompt blnam))
               (setq blnam ()))))
 blnam)
 ; Ŀ
 ;   Gnam end.                                                             
 ; 

 ; Ŀ
 ;   Blub - reinsert a block at a given scale.                             
 ;   Arguments: Enam, a block ename.                                       
 ;              Scal, the desired scale.                                   
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN BLUB (enam scal / esav entt pa namb rota layy main sub tagg cc)
 ; Ŀ
 ;   Find the block insertion, rotation and layer.                         
 ; 
  (setq esav enam)
  (setq entt (entget enam))
  (setq pa (cdr (assoc 10 entt)))
  (setq namb (cdr (assoc 2 entt)))
  (if (setq rota (cdr (assoc 50 entt)))
      (setq rota (/ (* 180 rota) pi))
      (setq rota 0))
  (setq layy (assoc 8 entt))
 ; Ŀ
 ;   Step through the block and get attribute tags and values.             
 ;   (if there are attributes - the 66 sublist is present.)                
 ; 
  (if (assoc 66 (entget enam))
      (while (and (setq enam (entnext enam))
                  (/= (cdr (assoc 0 (setq entt (entget enam)))) "SEQEND"))
             (setq sub (list (assoc 2 entt) (assoc 1 entt)))
             (setq main (append main (list sub)))))
 ; Ŀ
 ;   Now erase the old new block and insert the new one.                   
 ; 
  (entdel esav)
  (command "insert" namb pa scal "" rota)
  (setq esav (setq enam (entlast)))
 ; Ŀ
 ;   Reapply the attribute values.                                         
 ; 
  (while (and (setq enam (entnext enam))
              (/= (cdr (assoc 0 (setq entt (entget enam)))) "SEQEND"))
         (setq tagg (assoc 2 entt))
         (if (setq cc (assoc tagg main))
             (entmod (subst (cadr cc) (assoc 1 entt) entt))
             (entmod (subst (cons 1 "") (assoc 1 entt) entt))))
 ; Ŀ
 ;   Put the block on the correct layer.                                   
 ; 
  (setq entt (entget esav))
  (entmod (subst layy (assoc 8 entt) entt))
 (princ))
 ; Ŀ
 ;   Blub end.                                                             
 ; 

 ; Ŀ
 ;   Propx - scale a selected block.                                       
 ;   Arguments: Enam, a block ename.                                       
 ;              Scal, the desired scale.                                   
 ;   Calls nothing, returns nothing.                                       
 ;   Intended for use with attribute-free blocks.                          
 ; 
 (DEFUN PROPX (enam scal / entt)
  (setq entt (entget enam))
  (setq entt (subst (cons 41 scal) (assoc 41 entt) entt))
  (setq entt (subst (cons 42 scal) (assoc 42 entt) entt))
  (setq entt (subst (cons 43 scal) (assoc 43 entt) entt))
  (entmod entt)
 (princ))
 ; Ŀ
 ;   Propx end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Prop - select and scale blocks.                            
 ;   Arguments: Scal, the desired block scale.                             
 ;              Prom, the block selection prompt.                          
 ; 
 (DEFUN PROP (scal prom / limch atrq *error* ss num enam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq limch (getvar "limcheck"))
  (setvar "limcheck" 0)
  (setq atrq (getvar "attreq"))
  (setvar "attreq" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "attreq" atrq)
   (setvar "limcheck" limch)
   (command "undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get blocks to scale.                                                  
 ; 
  (prompt prom)
  (if (setq ss (ssget (list (cons 0 "insert"))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (if (assoc 66 (entget enam))
                      (blub enam scal)
                      (propx enam scal))
                  (setq num (1+ num)))))
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (*error* ())
 (princ))
 ; Ŀ
 ;   Subroutine Prop end.                                                  
 ; 

 ; Ŀ
 ;   Prop - scale selected blocks to dimscale.                             
 ; 
 (DEFUN C:PROP ()
  (prop (misps) "Select blocks to scale to dimscale:")
 (princ))

 ; Ŀ
 ;   P1 - scale selected blocks to 1.                                      
 ; 
 (DEFUN C:P1 ()
  (prop 1 "Select blocks to scale to 1:")
 (princ))

 ; Ŀ
 ;   Scabl - the big cheese.                                               
 ; 
 (DEFUN C:SCABL (/ *error* bl ss all newscp len num enam entt scal inss)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (if shk (print shk))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get blocks to scale.                                                  
 ; 
  (setq bl (gnam "Block name to scale all of or <Return> to select blocks: "))
  (if bl                      ; something input or block selected: have a name
      (setq ss (ssget "X" (list (cons 2 bl))))
      (setq ss (ssget (list (cons 0 "insert")))))
 ; Ŀ
 ;   Get new scale.                                                        
 ; 
  (if (/= (type newsc) 'REAL) (setq newsc 1))
  (setq newscp (getreal (strcat "\nNew scale <" (rtos newsc 2 2) ">: ")))
  (if newscp (setq newsc newscp))
 ; Ŀ
 ;   Now scale them all.                                                   
 ; 
  (if ss (setq len (sslength ss)))
  (setq num 0)
  (while (and ss (setq enam (ssname ss 0)))
         (setq entt (entget enam))
         (setq scal (abs (cdr (assoc 41 entt))))
         (if (/= scal newsc)
             (progn
                  (setq num (1+ num))
                  (setq inss (cdr (assoc 10 entt)))
                  (command "scale" enam "" inss (/ newsc scal))))
         (ssdel enam ss))
 ; Ŀ
 ;   Debrief the operative.                                                
 ; 
  (if len
     (prompt (strcat "\n" (itoa len) " insert" (if (= num 1) "" "s") " found"))
      (write-line "No blocks found."))
  (if (> num 0)
      (prompt (strcat ", " (itoa num) " rescaled."))
      (if len (prompt ".")))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))
